
$(function () {
	$.validator.setDefaults({
		submitHandler: function (form) {
			form.submit();
		}
	});
	$('#js-login-form').validate({
		rules: {
			email: {
				required: true,
				email: true,
			},
			password: {
				required: true,
				minlength: 9
			},
		},
		messages: {
			email: {
				required: "Please enter   email address",
				email: "Please enter a valid email address"
			},
			password: {
				required: 'Please enter a password',
				minlength: 'Password must be at least 9 characters long',
			},
		},
		errorElement: 'span',
		errorPlacement: function (error, element) {
			error.addClass('invalid-feedback');
			element.closest('.form-group').append(error);
		},
		highlight: function (element, errorClass, validClass) {
			$(element).addClass('is-invalid');
		},
		unhighlight: function (element, errorClass, validClass) {
			$(element).removeClass('is-invalid');
		}
	});
});